%{
What I need is a way to keep track of real pores and edge pores, with the 
ability to reference each independently, remove either type WITHOUT recalculating
and without messing up any indexing.  This might mean also keeping track of 
deleted pores.

A nice thing about the current system is that each pore boundary just keeps track of 
it's own pore number.  This number uniquely identifies that pore.  It is the index of 
the boundary in results.B, it is the number of the pixels in results.L, and it is the 
index of the pore's statistics in results.pores.

The trickiness comes in when a pore needs to be removed from the list.  In that case, 
the pore number is no longer necessarily the index into results.B or results.pores.  
Also, there are similar complications when we start to divide pores into normal and 
edge pores.  Should they be numbered independently, have an associated type, or what?

A solution might look something like this:  
Regular pores:
 label matrix  = results.L
 boundary cell array = results.B
 pores structure = results.pores
 results.pore_num_mapping
Edge pores:
 label matrix = results.edgepores_L
 boundary cell array = results.edgepores_B
 pores structure = results.edgepores (only area?)
 results.edgepore_num_mapping

Maybe simplest is to have all pores keep their original pore number, but what
else would that entail?  One approach would be to keep a number-to-index mapping
for each category.  However, then we'd have to determine for pore number 10, whether
it's edge or not, and then 

What if we made the edge pores negative in the label matrix?

Another idea, what if we added pore number to the pores structure?  And the boundary
also?  I like this idea so far. We could even add pore type (an edge flag or something).

OK, there is a way to do this.  Put a 1 in a field for every pore which isn't edge, and a 0 if
there is. Call this field nonedge_flag.  indices of pores which are not edge is then 
nonedge_pore_inds=find([pores.nonedge_flag]);

Now all pore info is internal to the pores structure.  When a pore number is deleted, 
the matching pore entry can somply be removed, and that number removed from the label
matrix.  The boundary will automatically be removed from the boundary list, and index 
into the pores structure is no longer important. 

What's left?  
- Remove auto-update on pore removal.  
- Modify how pores are displayed
- Make sure label matrix removal works
- Change view in the appropriate places
- add function to show that results are not current by changing the update results button red
- TEST TEST TEST!!!
- Check for anywhere else which uses the results.B information!!
- Update the documentation, it needs it. 
- Take a look at the histogram stuff, and fix it to only show the nonedge pores


%}

results.pores = regionprops(results.L,'EquivDiameter','Area','MajorAxisLength','MinorAxisLength','Centroid');
for pore_num = 1:length(B)
    results.pores(pore_num).boundary = B{pore_num};
    if ismember(pore_num,edge_pore_nums)
        results.pores(pore_num).non_edge_flag = 0;
    else
        results.pores(pore_num).non_edge_flag = 1;
    end
end


% to reconstitute B
B = {results.pores.boundary};

%%% in calc_stats
% use only non_edge pores for most stats

function nonedge_pores = find_nonedge_pores(pores_structure)
nonedge_pores = pores_structure(logical([pores_structure.non_edge_flag]));

function edge_pores = find_edge_pores(pores_structure)
edge_pores = pores_structure(~logical([pores_structure.non_edge_flag]));
