function pore_processing_gui_setup

param = getstyleparam('pore_processing');

fig = figure('Toolbar','figure'); % so zooming shows up automatically


%%%%%%%%%%%%%%% Create all UI Controls %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% Main image area
im_panel = uipan;
im_ax = axes('Parent',im_panel,'ActivePositionProperty','outerposition');
setappdata(fig,'image_ax',im_ax);

%%%% Organizing panels
commands_panel = uipan;
controls_panel = uipan;

load_crop_correct_panel = uipan;

%%%%% Processing commands area
% proc_panel = uipan(50,50,'Tag','proc_panel'); % outer container
% proc_t = uitext('Image Processing Commands');
%%% Original image
orig_panel = uipan; % for original image loading and cropping
orig_h = uitext('Original Image'); %section heading
fname_t = uitext('Filename:');
fname_e = uiedit('','Callback',{@pore_processing_gui_call,'load orig'});
fname_b = uipush('...','Callback',{@pore_processing_gui_call,'browse for orig'}); % browse for image
%load_b = uipush('Load','Callback',{@pore_processing_gui_call,'load orig'}); % load original image
orig_hs.filename = fname_e;
setappdata(fig,'original_hs',orig_hs);
%%% Cropping
crop_panel = uipan; % for setting cropping limits
crop_h = uitext('Cropping');
crop_t = uitext('Crop:');
crop_rbg = uibg; % radiobuttongroup
curaxlim_r = uiradio('To current axes limits');
manuallim_r = uiradio('To ');
limL_t = uitext('Xmin');
limL_e = uiedit;
limR_t = uitext('Xmax');
limR_e = uiedit;
limT_t = uitext('Ymax');
limT_e = uiedit;
limB_t = uitext('Ymin');
limB_e = uiedit;

% Set up data structure for cropping callback
crophandles.rbg = crop_rbg;
crophandles.curax = curaxlim_r;
crophandles.manual = manuallim_r;
crophandles.limL = limL_e;
crophandles.limR = limR_e;
crophandles.limT = limT_e;
crophandles.limB = limB_e;
setappdata(fig,'crop_handles',crophandles);
crop_b = uipush('Go','Callback',{@pore_processing_gui_call,'crop'});
%%% Background Correction
bgc_panel = uipan;
bgc_h = uitext('Background Correction');
filter_t = uitext('Filter Size:');
filter_e = uiedit('100','Callback',{@pore_processing_gui_call,'showfilter'});
filter_t2 = uitext('pixels');
showfilter_c = uicheck('Callback',{@pore_processing_gui_call,'showfilter'});
showfilter_t = uitext('Show filter on image');
bgc_hs.filtersize = filter_e;
bgc_hs.showfilter = showfilter_c;
setappdata(fig,'bgc_handles',bgc_hs);
bgc_b = uipush('Go','Callback',{@pore_processing_gui_call,'correct bg',crophandles});
%%% Thresholding
thresh_panel = uipan;
thresh_h = uitext('Threshold');
max_t = uitext('200');
gt1_t = uitext('>');
thresh_e = uiedit('10','Callback',{@pore_processing_gui_call,'thresh'});
gt2_t = uitext('>');
min_t = uitext('-200');
thresh_b = uipush('Go','Callback',{@pore_processing_gui_call,'thresh'});
% Gather thresh handles
thresh_hs.max = max_t;
thresh_hs.min = min_t;
thresh_hs.thresh = thresh_e;
setappdata(fig,'thresh_handles',thresh_hs);
%%% Binary operations
binop_panel = uipan;
binop_h = uitext('Binary Operations');
se_t = uitext('Structuring Element:');
se_rbg = uibg(50,50,'SelectionChangeFcn',{@pore_processing_gui_call,'update se'});
sedisk_r = uiradio('Disk, with radius');
sedisk_e = uiedit('2','Callback',{@pore_processing_gui_call,'update se'});
sesquare_r = uiradio('Square, with side');
sesquare_e = uiedit('2','Callback',{@pore_processing_gui_call,'update se'});
secustom_r = uiradio('Custom...');
curse_t = uitext('Current SE:');
se_panel = uipan;
se_ax = axes('Parent',se_panel,'ActivePositionProperty','outerposition');
% gather se handles
se_hs.rbg = se_rbg;
se_hs.disk_r = sedisk_r;
se_hs.disk_e = sedisk_e;
se_hs.square_r = sesquare_r;
se_hs.square_e = sesquare_e;
se_hs.custom_r = secustom_r;
se_hs.sepanel = se_panel;
se_hs.ax = se_ax;
setappdata(fig,'se_handles',se_hs);
% image operations
erode_b = uipush('Erode','Callback',{@pore_processing_gui_call,'erode'});
dilate_b = uipush('Dilate','Callback',{@pore_processing_gui_call,'dilate'});
open_b = uipush('Open','Callback',{@pore_processing_gui_call,'open'});
close_b = uipush('Close','Callback',{@pore_processing_gui_call,'close'});
majority_b = uipush('Majority','Callback',{@pore_processing_gui_call,'majority'});

%%% Algorithm Log
log_panel = uipan;
log_h = uitext('Algorithm Log');
log = uiedit('Algorithm Log','Max',2,'Enable','inactive');
setappdata(fig,'log_handle',log);
savelog_b = uipush('Save Algorithm...','Callback',{@pore_processing_gui_call,'savelog'});
loadlog_b = uipush('Load Algorithm...','Callback',{@pore_processing_gui_call,'loadlog'});

%%%% Results
res_panel = uipan;
res_col1_panel = uipan;
res_col2_panel = uipan;
res_h = uitext('Results');
%%% Histogram
hist_panel = uipan(50,100);
hist_ax = axes('Parent',hist_panel,'ActivePositionProperty','outerposition');
setappdata(fig,'hist_ax',hist_ax);
%%% Summary
summary_panel = uipan;
poredens_t = uitext('Pore Density:');
poredens_t2 = uitext('0.00e-003');
poredensunits_t = uitext('pores/pixel^2');
porosity_t = uitext('Porosity:');
porosity_t2 = uitext('0.000e-3');
summary_hs.poredens = poredens_t2;
summary_hs.poredensunits = poredensunits_t;
summary_hs.porosity = porosity_t2;
%%% Table
table_panel = uipan;
heading_strings = {'#','Diameter','Area','Major Axis','Minor Axis','Avg Intensity','Roundness'}; % Add roundness index?
heading_hs = zeros(size(heading_strings));
selpore_hs = heading_hs;
meanpore_hs = heading_hs;
for i = 1:length(heading_strings)
    heading_hs(i) = uitext(heading_strings{i});
    selpore_hs(i) = uitext('-');
    meanpore_hs(i) = uitext('-');
end
heading_spacer = uitext('');
selpore_rowheading = uitext('Selected Pore:');
meanpore_rowheading = uitext('Mean Pore:');
remove_b = uipush('Remove','Callback',{@pore_processing_gui_call,'remove pore'}); % button to remove currently selected pore from analysis
% gather table handles
table.heading_strings = heading_strings;
table.heading_hs = heading_hs;
table.selpore_hs = selpore_hs;
table.meanpore_hs = meanpore_hs;
%%% Calculate Results 
calc_panel = uipan;
calc_b = uipush('Update Results','Callback',{@pore_processing_gui_call,'update results'});

% Set Calibration
calib_rbg = uibg(50,50,'SelectionChangeFcn',{@pore_processing_gui_call,'pixpernm'});
calib_none_r = uiradio('None (use pixels)');
calib_manual_r = uiradio('Use ');
calib_manual_e = uiedit('5.1','Callback',{@pore_processing_gui_call,'pixpernm'});
calib_t2 = uitext('pixels/nm calibration');
calib_scope_r = uiradio('Use');
    % get microscope-based calibrations from file
    calib_info = parse_calibrations_file;
    scope_names = calib_info(:,1);
calib_p1 = uipopup({'Microscope', scope_names{:}},'Callback',{@pore_processing_gui_call,'microscope'});
calib_p2 = uipopup({'Magnification'},'Callback',{@pore_processing_gui_call,'pixpernm'});
% gather calibration handles
calib_hs.calib_rbg = calib_rbg;
calib_hs.calib_none_r = calib_none_r;
calib_hs.calib_manual_r = calib_manual_r;
calib_hs.calib_manual_e = calib_manual_e;
calib_hs.calib_t2 = calib_t2;
calib_hs.calib_scope_r = calib_scope_r;
calib_hs.calib_p1 = calib_p1;
calib_hs.calib_p2 = calib_p2;

% Size cut-off
properties = {'Area','Diameter','Major Axis','Minor Axis','Avg Intensity','Roundness'};
relations = {'>','>=','=','<=','<'};
units = {'pixels','nm'};
cutoff_panel = uipan;
cutoff_h = uitext('Remove Pores by Property');
cutoff_prop_p = uipopup(properties);
cutoff_rel_p = uipopup(relations);
cutoff_e = uiedit;
cutoff_units_p = uipopup(units);
cutoff_b = uipush('Remove','Callback',{@pore_processing_gui_call,'cutoff'});
% gather cutoff handles
cutoff_hs.cutoff_prop_p = cutoff_prop_p;
cutoff_hs.cutoff_rel_p = cutoff_rel_p;
cutoff_hs.cutoff_e = cutoff_e;
cutoff_hs.cutoff_units_p = cutoff_units_p;

% gather results handles
res_hs.calc_b = calc_b;
res_hs.calib = calib_hs;
res_hs.table = table;
res_hs.summary = summary_hs;
res_hs.hist_ax = hist_ax;
res_hs.cutoff = cutoff_hs;
setappdata(fig,'results_handles',res_hs);

%%%% Choose Mode
panels.load = load_crop_correct_panel;
panels.binop = binop_panel;
panels.log = log_panel;
panels.res = res_panel;
mode_p = uipopup({'Load, Crop, and Correct','Binary Operations','Algorithm Log','Results'});
setappdata(fig,'mode_p',mode_p);

%%%% View
view_panel = uipan;
view_t = uitext('View:');
view_rbg = uibg(5,5,'SelectionChangeFcn',{@pore_processing_gui_call,'change view'});
orig_r = uiradio('Original Image (cropped)');
bgc_r = uiradio('Background Corrected Image');
%thresh_r = uiradio('Threshold Image');
bw_r = uiradio('Current Black & White Image');
showbound_c = uicheck('Callback',{@pore_processing_gui_call,'pore boundaries'});
showbound_t = uitext('Show Pore Boundaries');
%gather view handles
view_hs.rbg = view_rbg;
view_hs.orig = orig_r;
view_hs.bgc = bgc_r;
%view_hs.thresh = thresh_r;
view_hs.bw = bw_r;
view_hs.showbound = showbound_c;
setappdata(fig,'view_handles',view_hs);


%%%% Status
status_panel = uipan;
status_t = uitext('Initializing GUI...');
setappdata(fig,'status_handle',status_t);

%%%%%%%%%%%%%%%%%%%% Categorize all UI Controls %%%%%%%%%%%%%%%%%%%%%%%%
% Containers
panel_h = [im_panel,commands_panel,controls_panel,load_crop_correct_panel,orig_panel,crop_panel,bgc_panel,thresh_panel,binop_panel,...
    crop_rbg,se_rbg,se_panel,log_panel,res_panel,hist_panel,summary_panel,table_panel,...
    calc_panel,calib_rbg,cutoff_panel,view_panel,view_rbg,status_panel,...
    res_col1_panel,res_col2_panel];

% Axes
axes_h = [im_ax,se_ax,hist_ax];

% Table Entries
table_h = [heading_hs, selpore_hs,meanpore_hs];
rowheading_h = [heading_spacer,selpore_rowheading,meanpore_rowheading];

% Text
% Title Text (title for whole main panel)
title_h = [res_h,view_t];
% Heading Text (title for subpanels of main panel)
heading_h = [orig_h,crop_h,bgc_h,thresh_h,binop_h,log_h,cutoff_h];
% Label text
label_h = [fname_t,crop_t,limL_t,limR_t,limT_t,limB_t,filter_t,filter_t2,max_t,gt1_t,...
    gt2_t,min_t,se_t,poredens_t,poredens_t2,poredensunits_t,porosity_t,porosity_t2,...
    calib_t2,showbound_t,showfilter_t,curse_t];
% Status
status_h = [status_t];

% Edit boxes
fourdigit_h = [limL_e,limR_e,limT_e,limB_e,sedisk_e,sesquare_e,thresh_e,filter_e,calib_manual_e,cutoff_e];
fname_h = fname_e;
scrolledit_h = [log]; %scrollable edit box

% Pushuttons
extent_push_h = [fname_b,bgc_b,thresh_b,savelog_b,loadlog_b,...
    calc_b,remove_b,crop_b,cutoff_b]; % sized to extent
binop_push_h = [erode_b,dilate_b,open_b,close_b,majority_b]; %fixed width

% Radio buttons
radio_h = [curaxlim_r,manuallim_r,sedisk_r,sesquare_r,secustom_r,orig_r,bgc_r,bw_r,...
    calib_none_r,calib_manual_r,calib_scope_r];

% Popup menus
popup_h = [mode_p,calib_p1,calib_p2,cutoff_prop_p,cutoff_rel_p,cutoff_units_p];

% Checkboxes
check_h = [showfilter_c,showbound_c];

%%%%%%%%%%%%%%%%%%%%%%%% Style all UI controls %%%%%%%%%%%%%%%%%%%%%%%%%%
stylegroups = {'panel','axes','table','rowheading','title','heading','label'...
    'status','fourdigit','filename','scrolledit','extent_push','binop_push',...
    'radio','popup','check'};
stylegroup_hs = {panel_h,axes_h, table_h,rowheading_h,title_h,heading_h,label_h,...
    status_h,fourdigit_h,fname_h,scrolledit_h,extent_push_h,binop_push_h,...
    radio_h,popup_h,check_h};

styleui(stylegroup_hs,param,stylegroups);


%%%%%%%%%%%%%%%%%%% Size all UI Controls %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

sizeui(stylegroup_hs,param,stylegroups);

%%%%%%%%%%%%%%%%%%%% Define GUI Layout %%%%%%%%%%%%%%%%%%%%%%%%%%%%

im_layout = {
    {'parent',im_panel,'xstretchfactor',5,'ystretchfactor',5};
    {im_ax};
    };

orig_layout = {
    {'parent',orig_panel};
    {orig_h};
    {fname_t,fname_e,fname_b};
%    {'right',load_b};
    };
crop_rbg_layout = {
    {'parent',crop_rbg};
    {curaxlim_r};
    {'ignoreline',manuallim_r,'settab1',limL_t,'settab2',limL_e,'space:5','settab3',limB_t,'settab4',limR_e};
    {manuallim_r,'tab1',limL_t,'tab2',limL_e,'tab3',limR_t,'tab4',limR_e,'ghost','space:14'};
    {'tab1',limB_t,'tab2',limB_e,'tab3',limT_t,'tab4',limT_e,};
    };
crop_layout = {
    {'parent',crop_panel};
    {crop_h};
    {'vmidalign',crop_t,crop_rbg_layout};
    {'right',crop_b};
    };
bgc_layout = {
    {'parent',bgc_panel};
    {bgc_h};
    {filter_t,filter_e,filter_t2};
    {showfilter_c,showfilter_t};
    {'right',bgc_b};
    };
thresh_layout = {
    {'parent',thresh_panel};
    {thresh_h};
    {max_t,gt1_t,thresh_e,gt2_t,min_t};
    {'right',thresh_b};
    };
se_panel_layout = {
    {'parent',se_panel};
    {se_ax};
    };
se_rbg_layout = {
    {'parent',se_rbg};
    {sedisk_r,sedisk_e};
    {sesquare_r,sesquare_e};
    {secustom_r};
    {'vmidalign',curse_t,se_panel_layout};
    };
binop_layout = {
    {'parent',binop_panel};
    {binop_h};
    {'vmidalign',se_t, se_rbg_layout};
    {'center',erode_b,dilate_b};
    {'center',open_b,close_b};
    {'center',majority_b};
    };
log_layout = {
    {'parent',log_panel};
    {log_h};
    {log};
    {savelog_b,'right',loadlog_b};
    };

% proc_layout = {
%     {'parent',proc_panel,'xstretchfactor',0,'ystretchfactor',5};
%     {proc_t};
%     {orig_layout};
%     {crop_layout};
%     {bgc_layout,thresh_layout};
%     {binop_layout};
%     {log_layout};
%     };

load_crop_correct_layout = {
    {'parent',load_crop_correct_panel};
    {orig_layout};
    {crop_layout};
    {bgc_layout};
    {thresh_layout};
    };

hist_layout = {
    {'parent',hist_panel,'xstretchfactor',1,'ystretchfactor',1};
    {hist_ax}
    };
summary_layout = {
    {'parent',summary_panel};
    {poredens_t,poredens_t2,poredensunits_t};
    {porosity_t,porosity_t2};
    };
headings_cell = mat2cell(heading_hs,1,ones(size(heading_hs)));
selpore_cell = mat2cell(selpore_hs,1,ones(size(selpore_hs)));
meanpore_cell = mat2cell(meanpore_hs,1,ones(size(meanpore_hs)));
% Here the table needs to be rotated to be vertical, and then each row
% encapsulated in it's own cell.
table_cell = cat(1,{heading_spacer,headings_cell{:}},{selpore_rowheading,selpore_cell{:}},{meanpore_rowheading,meanpore_cell{:}});
table_cell = table_cell';
table_layout = {{'parent',table_panel}};
for i = 1:size(table_cell,1)
    table_layout{i+1,1} = [table_cell(i,:)];
end
table_layout{end+1,1} = {'center',remove_b};

% table_layout = {
%     {'parent',table_panel};
%     {heading_spacer,headings_cell{:}};
%     {selpore_rowheading,selpore_cell{:},remove_b};
%     {meanpore_rowheading,meanpore_cell{:}};
%     };
calib_rbg_layout = {
    {'parent',calib_rbg};
    {calib_none_r};
    {calib_manual_r,calib_manual_e,calib_t2};
    {calib_scope_r,calib_p1,calib_p2};
    };
calc_layout = {
    {'parent',calc_panel};
    {calc_b};
    {calib_rbg_layout};
    %{calib_c,calib_t,calib_e,calib_t2};
    };
% res_layout = {
%     {'parent',res_panel,'xstretchfactor',1,'ystretchfactor',1};
%     {res_h};
%     {'vmidalign',calc_layout,hist_layout,summary_layout,table_layout,};
%     };
cutoff_layout = {
    {'parent',cutoff_panel};
    {cutoff_h};
    {cutoff_prop_p,cutoff_rel_p,cutoff_e,cutoff_units_p};
    {'center',cutoff_b};
    };

screensize = get(0,'screensize');

if screensize(4) < 800 % for small screens
    res_col1_layout = {
        {'parent',res_col1_panel};
        %{res_h};
        {calc_layout};
        {hist_layout};
        {cutoff_layout};
        };
    res_col2_layout = {
        {'parent',res_col2_panel};
        {summary_layout};
        {table_layout};
        };

    res_layout = {
        {'parent',res_panel};
        {res_h};
        {res_col1_layout, res_col2_layout};
        };
else
    res_layout = {
        {'parent',res_panel};
        {res_h};
        {calc_layout};
        {hist_layout};  % removed for Maryna to lessen height
        {summary_layout};
        {table_layout};
        {cutoff_layout};
        };
    delete([res_col1_panel,res_col2_panel]);
end
%% %%%
%set(hist_panel,'Visible','off')  % hiding it for Maryna
%% %%%
view_rbg_layout = {
    {'parent',view_rbg};
    {orig_r};
    {bgc_r};
%    {thresh_r};
    {bw_r};
    };
view_layout = {
    {'parent',view_panel,'xstretchfactor',1};
    {'vtopalign',view_t,'settab1',view_rbg_layout};
    {'tab1',showbound_c,showbound_t};
    };

status_layout = {
    {'parent',status_panel,'xstretchfactor',1,'ystretchfactor',.01};
    {'center',status_t};
    };

commands_layout_load = {
    {'parent',commands_panel,'ystretchfactor',1};
    {mode_p};
    {load_crop_correct_layout};
    {'vrubber:1'};
    };
commands_layout_binop = {
    {'parent',commands_panel,'ystretchfactor',1};
    {mode_p};
    {binop_layout};
    {'vrubber:1'};
    };
commands_layout_log = {
    {'parent',commands_panel,'ystretchfactor',1};
    {mode_p};
    {log_layout};
    {'vrubber:1'};
    };
commands_layout_res = {
    {'parent',commands_panel,'ystretchfactor',1};
    {mode_p};
    {res_layout};
    {'vrubber:1'};
    };

    function layout = make_layout(commands_layout)
        controls_layout = {
            {'parent', controls_panel,'ystretchfactor',1};
            {commands_layout};
            %    {'vrubber:1'};
            {view_layout};
            };
        % layout = {
        %     {'parent',fig};
        %     {proc_layout,im_layout};
        %     {res_layout,view_layout};
        %     {status_layout};
        %     };
        layout = {
            {'parent',fig};
            {controls_layout, im_layout};
            {status_layout};
            };

    end

layouts.load = make_layout(commands_layout_load);
layouts.binop = make_layout(commands_layout_binop);
layouts.log = make_layout(commands_layout_log);
layouts.res = make_layout(commands_layout_res);

set(mode_p,'Callback',{@pore_processing_gui_call,'change mode',mode_p,panels,layouts,param});

% controls_layout = {
%     {'parent', controls_panel,'ystretchfactor',1};
%     {commands_layout};
% %    {'vrubber:1'};    
%     {view_layout};
%     };
% % layout = {
% %     {'parent',fig};
% %     {proc_layout,im_layout};
% %     {res_layout,view_layout};
% %     {status_layout};
% %     };
% layout = {
%     {'parent',fig};
%     {controls_layout, im_layout};
%     {status_layout};
%     };

%%%%%%%%%%%%%%%%%%%% Position all UI Controls %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%keyboard;
% Run through all the tab layouts to position everything in it's panel once
gui_position(layouts.load,param);
gui_position(layouts.binop,param);
gui_position(layouts.log,param);
gui_position(layouts.res,param);
drawnow;

set(fig,'ResizeFcn',{@gui_position_wrapper,layouts.load,param});

pore_processing_gui_call([],[],'init'); % initialize gui

end %end outer fucntion