function [imdiff,blurred] = bgfix(im,method,varargin);
% this function removes the background from an image according to a given
% method (gaussian or disk).  Returns background-corrected image and
% background image.  Differs from original removebg by not rescaling the
% image
%
% method = blurring method, either 'gaussian', 'disk', or 'average'
% varargin = {size, standard dev} for gaussian, {disk radius} for disk, or
% {square side} for average
%
% method and varargin can actually correspond to any valid inputs to
% fspecial.m
%

% First the image is background corrected by blurring the image according
% to the specified method (originally 'disk' and 40 pixels)and subtracting
% the blurred image from the original
blurred = imblur(im,method,varargin{:});
imdiff = double(im)-double(blurred);

