% parse_inputs - script that writes the proper variables from a functions 
%                varariable input arguments to the workspace
%
%   Usage:  first, define  arg_list, variables and/or flags 
%           then call parse_inputs
%
%           varargin - varargin from the function (should already be
%           defined)
%           arg_list - list of possible indicators for input
%           variables - names of variables to be defined (must have 1 to 1
%                   correspondence to arg_list)
%           flags - names of flags (if the flag is seen, it will be set to
%                   1, otherwise, it will be zero)

if isempty(varargin), varargin{1} = ''; end
    
for argin_n = 1:length(varargin)  % replace numbers in input w/ empty strings
        if ~ischar(varargin{argin_n}), vararginS{argin_n} = ''; else vararginS{argin_n} = varargin{argin_n}; end
end

% set variables (altered by Mike)
if exist('arg_list')
    [prop_in,in_ind,prop_ind] = intersect(vararginS,arg_list);  % find entered properties
    for prop_num = 1:length(prop_in)
        this_num = in_ind(prop_num)+1;
        this_input = varargin{this_num};
        eval([variables{prop_ind(prop_num)} '= this_input;']);
    end
end

% Original version by Mort    
% % set variables
% if exist('arg_list');
%     [prop_in,in_ind,prop_ind] = intersect(vararginS,arg_list);  % find entered properties
%     for prop_num = 1:length(prop_in)
%         this_num = in_ind(prop_num)+1;
%         if isstruct(varargin{this_num})
%             thisinput = 'varargin{in_ind(prop_num)+1}';
%         elseif ~ischar(varargin{this_num}) & ~iscell(varargin{this_num}),      % handle numbers by changing them to strings
%             thisinput = num2str(varargin{this_num});
%         else thisinput = [''''' varargin{this_num} '''''];
%         end
%         try eval([ variables{prop_ind(prop_num)} '=[' thisinput '];']);
%         catch lasterr, end
%     end
% end

%set flags
if exist('flags')
    for flag_num = 1:length(flags);
        if ~isempty(intersect(vararginS,flags{flag_num}))
            flag_val = '1';
        else flag_val = '0';
        end
           eval([flags{flag_num} '=' flag_val ';']);
    end
end
% clear variables that don't need to be passed back
clear prop_in in_ind prop_ind argin_n prop_num vararginS thisinput